### What is your artist name?  
Queries  

### Could you tell us something about yourself, whereabouts, etc.?  
I grew up in the Pacific Northwest region of the USA, and I currently live in the Midwest region. I miss some things about where I grew up, but I also enjoy a lot of things about where I am now.  

I'm a dad and love helping kids learn new things and watching them experiment with the world.  

One of my hobbies is to use SunVox, participate in SunVox online communities, and work on "aftermarket" software that lets you extend SunVox in new and interesting ways.  

Writing software is also my profession. I have to be very careful not to spend too much hobby time on writing code! So, the coding part of the hobby tends to go in cycles.  

Other hobbies need my attention too! A good bike ride can clear my head pretty well.  

### Tell us an early memory about software & electronic music  
When I first started using trackers as a teen, I introduced it to one of my best friends, and he got hooked as well. At first, we made our own songs using samples from projects we downloaded.  

I quickly realized this was common practice because we'd play MOD files by completely different people and find that many used the same samples.  

Copying and remixing is part of early sampling culture in general, and I think the samples that were commonly passed around contributed a lot to the aesthetic of the MOD files from those early days.  

Someone had to sample those from somewhere, though. We wanted to develop our own styles, so we figured out how to hook up my dad's old Radio Shack mic to my 8-bit SoundBlaster Pro and proceeded to record a bunch of sounds based on nearby objects—things like a jar full of nuts and bolts, a wooden ruler held against a desk and slapped, popping sounds with our mouths.  

We were hooked on making our own samples!  

He extended his sample library with some recordings of him playing acoustic and electric guitar. I still like to mine his old files for lo-fi treats.  

One direction I went was to experiment with creating my own samples using code, by using QBASIC to calculate sample values and write them out to a file. I didn't know what they were called at the time, but I now recognize that as being "single-cycle" samples.  

### Why did you start using SunVox, and what did you use before that?  
I first ran into SunVox around 2014. I was looking for some modern trackers to play with. I barely remember using it, though—I just know that I found it in an old downloads folder, and it had that timestamp. There are some things in life that you run into more than once before you take notice, and SunVox was one of those things for me.  

In 2016, I tried it again. At that time, I was starting to explore the world of making music using my iPad. I saw mention of SunVox and got the Mac version again since it's free.  

Instead of exploring the tracker, I played around with the modular synth features. That's the part that "clicked" with me, and I became mildly obsessed with learning about SunVox, and synthesis in general, in a very deep way.  

Soon after, I paid for the iOS version of SunVox. I've spent more money on music software than I like to admit—and I still use a variety of apps—but SunVox is the audio app where I've spent more hours of time than any other.  

Before SunVox, for tracking, I first started with ScreamTracker 3, moved to Impulse Tracker, then finally [SchismTracker](http://schismtracker.org/). All are in the same family and have the same interface, keyboard shortcuts, etc. I have great respect for the [SchismTracker](http://schismtracker.org/) developers, since it lets me load up my oldest files and hear them accurately played.  

### Morning-person or Night owl? (or both?)  
Being a parent forces me to be a little of both!  

Most of my musical jams are at night, but I also like to get the kids involved during the day sometimes.  

When I have ideas in my mind about how to write some code, and they're not yet written down, I tend to be opportunistic about it. That is, whenever I get even 20 minutes to work on it.  

### Any particular inspiring SunVox song (by someone else) to mention?  
I'll always be a raver at heart. When I discovered that there was an LP of some brand-new music made in the UK hardcore style, produced entirely using SunVox, and pressed to a limited-edition vinyl, I jumped on it immediately. It's one of my favorite records in my collection, and not just because SunVox was used.  

The [post about it is here](https://warmplace.ru/forum/viewtopic.php?f=25&t=4872&p=18238).  

The album is here, and you can [listen here](https://kniteforce.bandcamp.com/album/kfw03-heavy-systems-inc-the-faceless-ep).  

### When did you start combining programming & SunVox?  
(You've created MetraSynth & Radiant Voices software for SunVox, how did that happen?)  

Around when I rediscovered SunVox, I also discovered the concept of "algoraves"—music events where people get together and artists perform by writing code to manipulate sound and video.  

This was exciting for me! I was getting back into DJ-ing after taking a long break away from it and quickly learned how to make use of my DJ controller as a generic MIDI device with SunVox and other non-DJ-specific apps.  

I saw that SunVox had a "DLL" version (now known as the "library" version), made for people to embed the SunVox audio engine into their own projects, such as for use by a game for its music and sound effects. As it turns out, it's easy to load that into almost any modern programming environment, including my favorite language: Python.  

Thus began my journey into documenting the SunVox file format, which led to creating Radiant Voices in 2016. That's a library for Python and JavaScript that lets you read SunVox projects, modify them with code, and write them back out.  

The most recent Metrasynth project is [sunvox.audio](https://sunvox.audio/), which aims to be "the world's best unofficial library of SunVox resources," to foster collaboration between artists, and to showcase their best projects and modules.  

### What are your plans for the future music-wise?  
As I write this, much of my music and coding efforts are going into "Querqi," a performance setup that combines all the MIDI controllers I've been accumulating, the SunVox library, Radiant Voices, and custom software. Updates can be found on my [YouTube Channel](https://www.youtube.com/c/QueriesMusic).  

### Where can people follow your latest software and/or music releases?  
[queries.rocks](https://queries.rocks) will redirect you to my sunvox.audio profile, which has all of my SunVox-related links.  

<span style="float:right">
	sunvox forum:&nbsp;
	<a class="btn" href="https://warmplace.ru/forum/search.php?keywords=queries">read more</a> 
	<a class="btn" href="https://www.warmplace.ru/forum/posting.php?mode=post&f=16">comment</a>
</span>
<div style="clear:both"></div>
